/* ============ */
/* maxgapln.c	*/
/* ============ */
#include <gapdefs.h>
#include <stdlib.h>
/* ==================================================================== */
/* GetMaxGapLen- Returns Maximum Gap Length For Interval & CellExpect	*/
/* ==================================================================== */
int
GetMaxGapLen(double LoLimit, double HiLimit, int CellExpect,
	     long MaxNumGaps, int MaxGapLen, double *GapProbs,
	     long *GapCtOut)
{
    int     k, m, WhereMax;
    long    NxtGapCt;
    double  MaxGapCt;

    *GapCtOut = -1;
    WhereMax  = -1;

    for (k = 0; k < MaxGapLen; ++k)
    {
	CalcGapProbs(k+1, LoLimit, HiLimit, GapProbs);

	MaxGapCt = -1;
	NxtGapCt = -1;
	for (m = k; m >= 0; --m)
	{
	    if (GapProbs[m] == 0)
	    {
		continue;
	    }
	    MaxGapCt =
		__max(MaxGapCt, (double)CellExpect/GapProbs[m]);
	}
	if (MaxGapCt > (double)MaxNumGaps)
	{
	    break;
	}
	else
	{
	    NxtGapCt = __max((long)MaxGapCt, NxtGapCt);

	    if (NxtGapCt == (long)MaxGapCt)
	    {
	    	WhereMax = k;
		*GapCtOut = NxtGapCt;
	    }
	}
    }
    return (WhereMax + 1);
}
